/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.TableDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomFieldDef
extends FieldDef {
    public AtomFieldDef(int lineNo, TableDef table, String name, String type, int displayOrder, Vector<FieldQualifier> qualifiers) throws IllegalityException {
        super(lineNo, table, name, type, type, displayOrder, qualifiers);
        table.addImport("org.melati.poem.ValidationPoemException", "persistent");
    }

    @Override
    protected void generateColRawAccessors(Writer w) throws IOException {
        super.generateColRawAccessors(w);
        w.write("\n          public Object getRaw(Persistent g)\n              throws AccessPoemException {\n            return ((" + this.shortestUnambiguousClassname + ")g).get" + this.capitalisedName + "();\n" + "          }\n" + "\n");
        w.write("          public void setRaw(Persistent g, Object raw)\n              throws AccessPoemException {\n            ((" + this.shortestUnambiguousClassname + ")g).set" + this.capitalisedName + "((" + this.rawType + ")raw);\n" + "          }\n");
    }

    @Override
    public void generateBaseMethods(Writer w) throws IOException {
        super.generateBaseMethods(w);
        w.write("\n /**\n  * Retrieves the " + this.capitalisedName + " value, with locking, for this \n" + "  * <code>" + this.table.nameFromDsd + "</code> <code>Persistent</code>.\n" + (this.description != null ? "  * Field description: \n" + DSD.javadocFormat(2, 3, this.description) : "") + "  * \n" + "  * Generated by " + "org.melati.poem.prepro.AtomFieldDef" + "#generateBaseMethods \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer write access rights \n" + "  * @return the value of the field <code>" + this.capitalisedName + "</code> for this \n" + "  *         <code>" + this.table.nameFromDsd + "</code> <code>Persistent</code>  \n" + "  */\n");
        w.write("\n  public " + this.typeShortName + " get" + this.capitalisedName + "()\n" + "      throws AccessPoemException {\n" + "    readLock();\n" + "    return get" + this.capitalisedName + "_unsafe();\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Sets the <code>" + this.capitalisedName + "</code> value, with checking, for this \n" + "  * <code>" + this.table.nameFromDsd + "</code> <code>Persistent</code>.\n" + (this.description != null ? "  * Field description: \n" + DSD.javadocFormat(2, 3, this.description) : "") + "  * \n" + "  * Generated by " + "org.melati.poem.prepro.AtomFieldDef" + "#generateBaseMethods  \n" + "  * @param cooked  a validated <code>int</code> \n" + "  * @throws AccessPoemException \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer write access rights\n" + "  * @throws ValidationPoemException \n" + "  *         if the value is not valid\n" + "  */\n");
        w.write("  public void set" + this.capitalisedName + "(" + this.typeShortName + " cooked)\n" + "      throws AccessPoemException, ValidationPoemException {\n" + "    _" + this.tableAccessorMethod + "().get" + this.capitalisedName + "Column().\n" + "      getType().assertValidCooked(cooked);\n" + "    writeLock();\n" + "    set" + this.capitalisedName + "_unsafe(cooked);\n" + "  }\n");
    }

    @Override
    public void generateJavaDeclaration(Writer w) throws IOException {
        w.write(this.typeShortName + " " + this.name);
    }

    @Override
    public String poemTypeJava() {
        return "new " + this.typeShortName + "PoemType(" + this.isNullable() + ")";
    }
}

