/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.TableDef;
import org.melati.poem.prepro.TableNamingInfo;

public class ReferenceFieldDef
extends FieldDef {
    String integrityfix;

    public ReferenceFieldDef(int lineNo, TableDef table, String name, int displayOrder, String type, Vector<FieldQualifier> qualifiers) throws IllegalityException {
        super(lineNo, table, name, type, "Integer", displayOrder, qualifiers);
        table.addImport("org.melati.poem.ReferencePoemType", "table");
        table.addImport("org.melati.poem.NoSuchRowPoemException", "persistent");
        if (this.integrityfix != null) {
            table.addImport("org.melati.poem.StandardIntegrityFix", "table");
        }
        table.addImport(type, "table");
        table.addImport(type, "persistent");
    }

    public TableNamingInfo getTargetTableNamingInfo() {
        return this.table.dsd.nameStore.tablesByShortName.get(this.typeShortName);
    }

    @Override
    protected void generateColRawAccessors(Writer w) throws IOException {
        super.generateColRawAccessors(w);
        w.write("\n          public Object getRaw(Persistent g)\n              throws AccessPoemException {\n            return ((" + this.shortestUnambiguousClassname + ")g).get" + this.capitalisedName + "Troid();\n" + "          }\n" + "\n");
        w.write("          public void setRaw(Persistent g, Object raw)\n              throws AccessPoemException {\n            ((" + this.shortestUnambiguousClassname + ")g).set" + this.capitalisedName + "Troid((" + this.rawType + ")raw);\n" + "          }\n");
        if (this.integrityfix != null) {
            w.write("\n          public StandardIntegrityFix defaultIntegrityFix() {\n            return StandardIntegrityFix." + this.integrityfix + ";\n" + "          }\n");
        }
    }

    private String targetCast() {
        if (this.getTargetTableNamingInfo() == null) {
            throw new ParsingDSDException(this.lineNumber, "Reference to a type (" + this.typeShortName + ") which has yet to be defined. \n" + "If there are no reciprocal references then reorder definitions.");
        }
        return this.getTargetTableNamingInfo() == null || this.getTargetTableNamingInfo().superclass == null ? "" : "(" + this.typeShortName + ")";
    }

    @Override
    public void generateBaseMethods(Writer w) throws IOException {
        super.generateBaseMethods(w);
        String targetTableAccessorMethod = "get" + this.typeShortName + "Table";
        String targetSuffix = this.typeShortName;
        String db = "get" + this.table.dsd.databaseTablesClassName + "()";
        w.write("\n /**\n  * Retrieves the Table Row Object ID. \n  *\n  * Generated by org.melati.poem.prepro.ReferenceFieldDef#generateBaseMethods \n  * @throws AccessPoemException  \n  *         if the current <code>AccessToken</code> \n  *         does not confer read access rights \n  * @return the TROID as an <code>Integer</code> \n  */\n");
        w.write("\n  public Integer get" + this.capitalisedName + "Troid()\n" + "      throws AccessPoemException {\n" + "    readLock();\n" + "    return get" + this.capitalisedName + "_unsafe();\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Sets the Table Row Object ID. \n  * \n  * Generated by org.melati.poem.prepro.ReferenceFieldDef#generateBaseMethods \n  * @param raw  a Table Row Object Id \n  * @throws AccessPoemException  \n  *         if the current <code>AccessToken</code> \n  *         does not confer write access rights\n  */\n");
        w.write("  public void set" + this.capitalisedName + "Troid(Integer raw)\n" + "      throws AccessPoemException {\n" + "    set" + this.capitalisedName + "(" + "raw == null ? null : \n" + "        " + this.targetCast() + db + "." + targetTableAccessorMethod + "()." + "get" + targetSuffix + "Object(raw));\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Retrieves the <code>" + this.capitalisedName + "</code> object referred to.\n" + "  *  \n" + "  * Generated by " + "org.melati.poem.prepro.ReferenceFieldDef" + "#generateBaseMethods \n" + "  * @throws AccessPoemException  \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer read access rights \n" + "  * @throws NoSuchRowPoemException  \n" + "  *         if the <code>Persistent</code> has yet " + "to be allocated a TROID \n" + "  * @return the <code>" + this.capitalisedName + "</code> as a <code>" + this.typeShortName + "</code> \n" + "  */\n");
        w.write("  public " + this.typeShortName + " get" + this.capitalisedName + "()\n" + "      throws AccessPoemException, NoSuchRowPoemException {\n" + "    Integer troid = get" + this.capitalisedName + "Troid();\n" + "    return troid == null ? null :\n" + "        " + this.targetCast() + db + "." + targetTableAccessorMethod + "()." + "get" + targetSuffix + "Object(troid);\n" + "  }\n" + "\n");
        w.write("\n /**\n  * Set the " + this.capitalisedName + ".\n" + "  * \n" + "  * Generated by " + "org.melati.poem.prepro.ReferenceFieldDef" + "#generateBaseMethods \n" + "  * @param cooked  a validated <code>" + this.typeShortName + "</code>\n" + "  * @throws AccessPoemException  \n" + "  *         if the current <code>AccessToken</code> \n" + "  *         does not confer write access rights \n" + "  */\n");
        w.write("  public void set" + this.capitalisedName + "(" + this.typeShortName + " cooked)\n" + "      throws AccessPoemException {\n" + "    _" + this.tableAccessorMethod + "().\n" + "      get" + this.capitalisedName + "Column().\n" + "        getType().assertValidCooked(cooked);\n" + "    writeLock();\n" + "    if (cooked == null)\n" + "      set" + this.capitalisedName + "_unsafe(null);\n" + "    else {\n" + "      cooked.existenceLock();\n" + "      set" + this.capitalisedName + "_unsafe(cooked.troid());\n" + "    }\n" + "  }\n");
    }

    @Override
    public void generateJavaDeclaration(Writer w) throws IOException {
        w.write("Integer " + this.name);
    }

    @Override
    public String poemTypeJava() {
        String targetTableAccessorMethod = "get" + this.typeShortName + "Table";
        String db = "get" + this.table.dsd.databaseTablesClassName + "()";
        return "new ReferencePoemType(" + db + ".\n" + "                                             " + targetTableAccessorMethod + "(), " + this.isNullable() + ")";
    }
}

