/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.ParsingDSDException;

public class SearchabilityFieldQualifier
extends FieldQualifier {
    private String searchability;

    public SearchabilityFieldQualifier(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        DSD.expect(tokens, '=');
        tokens.nextToken();
        if (tokens.ttype != -3) {
            throw new ParsingDSDException("<searchability level name>", tokens);
        }
        this.searchability = this.validSearchabilityNamed(tokens.sval);
        tokens.nextToken();
    }

    private String validSearchabilityNamed(String sval) {
        if (sval.equals("primary") || sval.equals("yes") || sval.equals("no")) {
            return sval;
        }
        throw new ParsingDSDException("<searchability level name>: one of primary, yes or no", sval);
    }

    @Override
    public void apply(FieldDef field) throws IllegalityException {
        field.searchability = this.searchability;
    }
}

