/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.DSD;
import org.melati.poem.prepro.FieldDef;
import org.melati.poem.prepro.FieldQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.ParsingDSDException;

public class DisplayOrderPriorityFieldQualifier
extends FieldQualifier {
    private int priority;

    public DisplayOrderPriorityFieldQualifier(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        DSD.expect(tokens, '=');
        tokens.nextToken();
        if (tokens.ttype != -2 || (int)tokens.nval < 0) {
            throw new ParsingDSDException("<positive priority number>", tokens);
        }
        this.priority = (int)tokens.nval;
        tokens.nextToken();
    }

    @Override
    public void apply(FieldDef field) throws IllegalityException {
        if (field.displayOrderPriority != -1) {
            throw new IllegalityException(field.lineNumber, "DisplayOrderPriority already set to " + field.displayOrderPriority + " cannot overwrite with " + this.priority);
        }
        field.displayOrderPriority = this.priority;
    }
}

