/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.prepro;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.melati.poem.prepro.CacheSizeTableQualifier;
import org.melati.poem.prepro.CategoryTableQualifier;
import org.melati.poem.prepro.DescriptionTableQualifier;
import org.melati.poem.prepro.DisplayNameTableQualifier;
import org.melati.poem.prepro.DisplayOrderTableQualifier;
import org.melati.poem.prepro.IllegalityException;
import org.melati.poem.prepro.ParsingDSDException;
import org.melati.poem.prepro.SeqCachedTableQualifier;
import org.melati.poem.prepro.TableDef;

public abstract class TableQualifier {
    public abstract void apply(TableDef var1) throws IllegalityException;

    public static TableQualifier from(StreamTokenizer tokens) throws ParsingDSDException, IOException {
        TableQualifier it;
        if (tokens.ttype != -3) {
            throw new ParsingDSDException("<table qualifier>", tokens);
        }
        String kind = tokens.sval;
        tokens.nextToken();
        if (kind.equals("displayname")) {
            it = new DisplayNameTableQualifier(tokens);
        } else if (kind.equals("description")) {
            it = new DescriptionTableQualifier(tokens);
        } else if (kind.equals("cachelimit")) {
            it = new CacheSizeTableQualifier(tokens);
        } else if (kind.equals("seqcached")) {
            it = new SeqCachedTableQualifier();
        } else if (kind.equals("category")) {
            it = new CategoryTableQualifier(tokens);
        } else if (kind.equals("displayorder")) {
            it = new DisplayOrderTableQualifier(tokens);
        } else {
            throw new ParsingDSDException("<table qualifier>", kind, tokens);
        }
        return it;
    }
}

