/*
 * Decompiled with CFR 0.152.
 */
package org.melati.example.contacts;

import java.io.IOException;
import org.melati.Melati;
import org.melati.PoemContext;
import org.melati.example.contacts.Contact;
import org.melati.example.contacts.ContactCategory;
import org.melati.example.contacts.ContactsDatabase;
import org.melati.example.contacts.ContactsServlet;
import org.melati.poem.Persistent;
import org.melati.servlet.Form;
import org.melati.servlet.PathInfoException;
import org.melati.template.ServletTemplateContext;

public class ContactView
extends ContactsServlet {
    private static final long serialVersionUID = 1L;

    protected String doTemplateRequest(Melati melati, ServletTemplateContext context) throws Exception {
        ContactsDatabase db = (ContactsDatabase)melati.getDatabase();
        Contact contact = (Contact)melati.getObject();
        if (melati.getMethod().equals("Insert")) {
            contact = (Contact)db.getContactTable().newPersistent();
        } else {
            if (melati.getMethod().equals("Update")) {
                if (contact == null) {
                    contact = (Contact)db.getContactTable().newPersistent();
                    Form.extractFields((ServletTemplateContext)melati.getServletTemplateContext(), (Persistent)contact);
                    db.getContactTable().create((Persistent)contact);
                } else {
                    Form.extractFields((ServletTemplateContext)melati.getServletTemplateContext(), (Persistent)contact);
                }
                this.deleteCategories(db, contact);
                String[] categories = melati.getRequest().getParameterValues("field_category");
                if (categories != null) {
                    for (int i = 0; i < categories.length; ++i) {
                        ContactCategory contactCategory = (ContactCategory)db.getContactCategoryTable().newPersistent();
                        contactCategory.setContact(contact);
                        contactCategory.setCategoryTroid(new Integer(categories[i]));
                        db.getContactCategoryTable().create((Persistent)contactCategory);
                    }
                }
                try {
                    melati.getResponse().sendRedirect(melati.getZoneURL() + "/org.melati.example.contacts.Search/contacts");
                }
                catch (IOException e) {
                    throw new Exception(e.toString());
                }
                return null;
            }
            if (melati.getMethod().equals("Delete")) {
                this.deleteCategories(db, contact);
                contact.deleteAndCommit();
                try {
                    melati.getResponse().sendRedirect(melati.getZoneURL() + "/org.melati.example.contacts.Search/contacts");
                }
                catch (IOException e) {
                    throw new Exception(e.toString());
                }
                return null;
            }
            if (!melati.getMethod().equals("View")) {
                throw new Exception("Invalid Method");
            }
        }
        context.put("contact", (Object)contact);
        context.put("categories", (Object)db.getCategoryTable().selection());
        return "org/melati/example/contacts/ContactView";
    }

    public void deleteCategories(ContactsDatabase db, Contact contact) {
        db.sqlUpdate("DELETE FROM " + db.quotedName("contactcategory") + " WHERE " + db.quotedName("contact") + " = " + contact.getTroid());
    }

    protected PoemContext poemContext(Melati melati) throws PathInfoException {
        return this.poemContextWithLDB(melati, "contacts");
    }
}

