/*
 * Decompiled with CFR 0.152.
 */
package org.melati.poem.odmg;

import java.util.HashMap;
import java.util.Map;
import org.melati.LogicalDatabase;
import org.melati.poem.odmg.ODMGFactory;
import org.melati.poem.odmg.PoemTableAsDCollection;
import org.melati.util.DatabaseInitException;
import org.odmg.DatabaseClosedException;
import org.odmg.NotImplementedException;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;
import org.odmg.ObjectNameNotFoundException;

final class Database
implements org.odmg.Database {
    private org.melati.poem.Database _poemDB = null;
    private String _logicalDB = null;
    private Map<String, PoemTableAsDCollection> _cachedTables = null;

    private Database() {
    }

    static Database getNewDatabase() {
        return new Database();
    }

    org.melati.poem.Database getPoemDatabase() throws ODMGRuntimeException {
        if (this._poemDB == null) {
            throw new DatabaseClosedException("org.melati.poem.odmg.Database::getPoemDatabase - POEM DB not set");
        }
        return this._poemDB;
    }

    public void open(String openParameters, int openType) throws ODMGException {
        this._logicalDB = openParameters;
        try {
            this._poemDB = LogicalDatabase.getDatabase((String)this._logicalDB);
            this._cachedTables = new HashMap<String, PoemTableAsDCollection>();
        }
        catch (DatabaseInitException err) {
            err.printStackTrace();
            throw new ODMGException(err.getMessage());
        }
    }

    public void close() {
        this._poemDB.disconnect();
        this._poemDB = null;
        this._cachedTables = null;
        ODMGFactory.resetDb();
    }

    public Object lookup(String objectIdentifier) throws ObjectNameNotFoundException {
        if (this._poemDB == null) {
            throw new DatabaseClosedException();
        }
        PoemTableAsDCollection theObject = this._cachedTables.get(objectIdentifier);
        if (theObject == null) {
            theObject = new PoemTableAsDCollection(this._poemDB.getTable(objectIdentifier));
            this._cachedTables.put(objectIdentifier, theObject);
        }
        return theObject;
    }

    public void makePersistent(Object objectToBePersistent) {
        throw new NotImplementedException();
    }

    public void deletePersistent(Object persistedObject) {
        throw new NotImplementedException();
    }

    public void bind(Object objectToBePersistent, String objectIdentifier) {
        throw new NotImplementedException();
    }

    public void unbind(String objectIdentifier) {
        throw new NotImplementedException();
    }
}

