/*
 * Decompiled with CFR 0.152.
 */
package org.melati.example.odmg;

import java.util.Collection;
import java.util.Iterator;
import org.melati.example.odmg.Parent;
import org.melati.poem.odmg.ODMGFactory;
import org.odmg.DCollection;
import org.odmg.Database;
import org.odmg.Transaction;

public final class OdmgTest {
    private OdmgTest() {
    }

    public static void main(String[] argsIn) throws Exception {
        Parent p;
        System.out.println("OdmgTest started:");
        Database db = ODMGFactory.getNewDatabase();
        System.out.println("Got a db = " + db);
        db.open("odmgplaying", 2);
        Transaction tx = ODMGFactory.getNewTransaction(db);
        tx.begin();
        DCollection parents = (DCollection)db.lookup("parent");
        parents.removeAll((Collection)parents);
        System.out.println("ADDING PARENTS");
        for (int i = 0; i < 10; ++i) {
            p = OdmgTest.newParent();
            p.setName("parent-" + parents.size());
            System.out.println("Adding parent: " + p.getName());
            parents.add((Object)p);
        }
        System.out.println("PARENTS DESCENDING");
        Iterator iter = parents.select("order by name desc");
        while (iter.hasNext()) {
            p = (Parent)((Object)iter.next());
            System.out.println("Parent:" + p.getName());
        }
        System.out.println("PARENTS UNDER 5 ASCENDING");
        iter = parents.select("where name<'parent-5' order by name asc");
        while (iter.hasNext()) {
            p = (Parent)((Object)iter.next());
            System.out.println("Parent:" + p.getName());
        }
        System.out.println("PARENTS UNDER 3 NO SORTING");
        iter = parents.select("name<'parent-3'");
        while (iter.hasNext()) {
            p = (Parent)((Object)iter.next());
            System.out.println("Parent:" + p.getName());
        }
        System.out.println("PARENTS UNDER 2 WITH WHERE KEYWORD NO SORTING");
        iter = parents.select("where name<'parent-2'");
        while (iter.hasNext()) {
            p = (Parent)((Object)iter.next());
            System.out.println("Parent:" + p.getName());
        }
        System.out.println("ALL PARENTS NO SORTING");
        iter = parents.select("");
        while (iter.hasNext()) {
            p = (Parent)((Object)iter.next());
            System.out.println("Parent:" + p.getName());
        }
        tx.commit();
        System.out.println("OdmgTest done:");
    }

    private static Parent newParent() throws Exception {
        return (Parent)ODMGFactory.getPoemDatabase().getTable("parent").newPersistent();
    }
}

